/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.actprof;

import com.ibm.hwmca.base.actprof.ActivationProfile;
import com.ibm.hwmca.base.actprof.ActivationProfileList;
import com.ibm.hwmca.base.actprof.ActivationProfileListBean;
import com.ibm.hwmca.base.actprof.ActivationProfileListConstants;
import com.ibm.hwmca.base.actprof.ActivationProfileListErrorIds;
import com.ibm.hwmca.base.actprof.ActivationProfileListPanelBean;
import com.ibm.hwmca.base.actprof.ActivationProfileUtil;
import com.ibm.hwmca.base.actprof.ProfileReport;
import com.ibm.hwmca.base.util.BaseMessageText;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.log.LogAttributes;
import com.ibm.hwmca.fw.managed.HwmcaObject;
import com.ibm.hwmca.fw.managed.ObjectId;
import com.ibm.hwmca.fw.report.CompletionReportCode;
import com.ibm.hwmca.fw.task.HwmcaPanelTasklet;
import com.ibm.hwmca.fw.tasklet.DisplayAreaDescriptor;
import com.ibm.hwmca.fw.tasklet.DisplayAreaDescriptorData;
import com.ibm.hwmca.fw.tasklet.PanelTasklet;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.tasklet.PanelTaskletResponse;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.MessageText;
import com.ibm.hwmca.fw.util.Trace;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.HashMap;

public class ActivationProfileListTasklet
extends HwmcaPanelTasklet
implements ActivationProfileListErrorIds,
ActivationProfileListConstants,
PropertyChangeListener {
    private static final String TRACE_MASKT = "XPROTSKT";
    private static final String TRACE_MASKF = "XPROTSKF";
    private static final String TRACE_MASKD = "XPROTSKD";
    protected ActivationProfileUtil util;
    private ActivationProfile lastEditedProfile = null;
    private boolean viewOnly = false;
    private Object hwmcaPanelTaskletData;
    static /* synthetic */ Class class$com$ibm$hwmca$fw$managed$HwmcaObject;

    public void logException(Throwable throwable) {
        new FrameworkLog(ActivationProfileListErrorIds._logInfo, -23296, throwable).log();
    }

    public void init(Object data) throws TaskletException {
        Trace.trace(TRACE_MASKF, "<> init");
        this.hwmcaPanelTaskletData = this.getRedirectData();
        super.init(data);
    }

    public void destroy() {
        Trace.trace(TRACE_MASKF, "<> ActivationProfileListTasklet.destroy()");
        this.removePropertyChangeListener("SubtaskletChildrenProperty", this);
        super.destroy();
    }

    public boolean isViewOnly() {
        return this.viewOnly;
    }

    public void service(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        Trace.trace(TRACE_MASKT, "-> ActivationProfileListTasklet.service()");
        if (request.isInitialRequest()) {
            ActivationProfileListBean[] beans;
            this.addPropertyChangeListener("SubtaskletChildrenProperty", this);
            this.util = new ActivationProfileUtil();
            this.showBusyDialog(this.getTask().getUIInfo().getUnlocalizedName(), new LocalizableText("com.ibm.hwmca.base.actprof.res.ActivationProfileListRes", "CollectingProfilesBusy.Msg"));
            Object o = request.getData("viewOnly");
            if (o != null && Boolean.TRUE.equals(o)) {
                this.viewOnly = true;
            }
            if ((o = request.getData("LastEditedProfile")) != null && request.getData("LastEditedProfile") instanceof ActivationProfile) {
                this.lastEditedProfile = (ActivationProfile)request.getData("LastEditedProfile");
            }
            if ((beans = this.util.buildBeans(this.getObjectsForIds(this.presentationTaskParms.getTargetIds(), class$com$ibm$hwmca$fw$managed$HwmcaObject == null ? (class$com$ibm$hwmca$fw$managed$HwmcaObject = ActivationProfileListTasklet.class$("com.ibm.hwmca.fw.managed.HwmcaObject")) : class$com$ibm$hwmca$fw$managed$HwmcaObject), this)) == null) {
                this.destroyBusyDialog();
                response.terminate();
            } else {
                for (int i = 0; i < beans.length; ++i) {
                    beans[i].setLastEditedProfile(this.lastEditedProfile);
                }
                DisplayAreaDescriptor[] tabs = new DisplayAreaDescriptorData[beans.length];
                for (int i = 0; i < tabs.length; ++i) {
                    tabs[i] = new DisplayAreaDescriptorData("com.ibm.hwmca.base.actprof.res.ActivationProfileListRes", "ActivationProfileListPanel", beans[i], ((ActivationProfile)beans[i].getData().get(0)).getMachineName(), null, "ActivationProfileListTPane");
                }
                ActivationProfileListPanelBean frameBean = new ActivationProfileListPanelBean();
                frameBean.setBeanName("ProfileListFrame");
                DisplayAreaDescriptorData frame = new DisplayAreaDescriptorData("com.ibm.hwmca.base.actprof.res.ActivationProfileListRes", "ActivationProfileListTPanel", frameBean, null, null);
                this.destroyBusyDialog();
                response.replace(frame, tabs);
            }
        } else if (request.isCanceled() || request.isDisposed()) {
            Trace.trace(TRACE_MASKT, "Terminating the tasklet");
            response.terminate();
        } else if (((String)request.getData("command")).equals("DeleteButton")) {
            this.handleDelete(request, response);
        } else if (((String)request.getData("command")).equals("CustomizeButton")) {
            this.handleCustomize(request, response);
        } else if (((String)request.getData("command")).equals("CmdRedirect")) {
            HashMap<String, Serializable> redirectInitData = new HashMap<String, Serializable>();
            redirectInitData.put("viewOnly", new Boolean(this.viewOnly));
            redirectInitData.put("LastEditedProfile", this.lastEditedProfile);
            Trace.trace(TRACE_MASKF, "starting redirect");
            response.redirect(this.getClass().getName(), this.hwmcaPanelTaskletData, this.presentationTaskParms, redirectInitData);
        } else {
            Trace.trace(TRACE_MASKF, "Invalid State!");
            new FrameworkLog(ActivationProfileListErrorIds._logInfo, -23296).log(LogAttributes.ERROR_LOG);
            response.terminate();
        }
        Trace.trace(TRACE_MASKT, "<- ActivationProfileListTasklet.service()");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void handleDelete(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        block33: {
            block32: {
                ObjectId objId;
                ActivationProfileList impl;
                ActivationProfile profile;
                block30: {
                    block29: {
                        Trace.trace(TRACE_MASKF, "-> ActivationProfileListTasklet.handleDelete()");
                        profile = (ActivationProfile)request.getData("profile");
                        if (this.viewOnly || !this.okToDelete(profile)) break block32;
                        this.showBusyDialog(this.getTask().getUIInfo().getUnlocalizedName(), new LocalizableText("com.ibm.hwmca.base.actprof.res.ActivationProfileListRes", "WorkingBusy.Msg"));
                        Trace.trace(TRACE_MASKT, "ok to delete");
                        impl = null;
                        objId = profile.getObjectId();
                        try {
                            try {
                                impl = this.util.findOwningImpl(profile, this.getObjectsForIds(this.presentationTaskParms.getTargetIds()));
                            }
                            catch (HException he) {
                                Trace.trace(TRACE_MASKF, "Could not find owning impl for: " + profile);
                                int i = 0;
                                while (true) {
                                    if (i >= this.presentationTaskParms.getTargetIds().length) {
                                        new FrameworkLog(ActivationProfileListErrorIds._logInfo, -23290, he).log(LogAttributes.INFO_LOG);
                                        throw new TaskletException(he);
                                    }
                                    Trace.trace(TRACE_MASKF, "PTP[" + i + "]:" + this.presentationTaskParms.getTargetIds()[i].toString());
                                    ++i;
                                }
                            }
                            Object var9_6 = null;
                            if (impl != null) break block29;
                        }
                        catch (Throwable throwable) {
                            Object var9_7 = null;
                            if (impl == null) {
                                Trace.trace(TRACE_MASKF, "impl was null for: " + profile);
                                for (int i = 0; i < this.presentationTaskParms.getTargetIds().length; ++i) {
                                    Trace.trace(TRACE_MASKF, "PTP[" + i + "]:" + this.presentationTaskParms.getTargetIds()[i].toString());
                                }
                                new FrameworkLog(ActivationProfileListErrorIds._logInfo, -23290).log(LogAttributes.INFO_LOG);
                            }
                            throw throwable;
                        }
                        Trace.trace(TRACE_MASKF, "impl was null for: " + profile);
                        for (int i = 0; i < this.presentationTaskParms.getTargetIds().length; ++i) {
                            Trace.trace(TRACE_MASKF, "PTP[" + i + "]:" + this.presentationTaskParms.getTargetIds()[i].toString());
                        }
                        new FrameworkLog(ActivationProfileListErrorIds._logInfo, -23290).log(LogAttributes.INFO_LOG);
                    }
                    try {
                        try {
                            if (objId == null) {
                                objId = this.util.findOwningTarget(profile, impl, this.getObjectsForIds(this.presentationTaskParms.getTargetIds()));
                            }
                        }
                        catch (HException he) {
                            Trace.trace(TRACE_MASKF, "Could not objId for: " + profile);
                            int i = 0;
                            while (true) {
                                if (i >= this.presentationTaskParms.getTargetIds().length) {
                                    new FrameworkLog(ActivationProfileListErrorIds._logInfo, -23290, he).log(LogAttributes.INFO_LOG);
                                    throw new TaskletException(he);
                                }
                                Trace.trace(TRACE_MASKF, "PTP[" + i + "]:" + this.presentationTaskParms.getTargetIds()[i].toString());
                                ++i;
                            }
                        }
                        Object var12_19 = null;
                        if (objId != null) break block30;
                    }
                    catch (Throwable throwable) {
                        Object var12_20 = null;
                        if (objId == null) {
                            Trace.trace(TRACE_MASKF, "objId was null for: " + profile);
                            for (int i = 0; i < this.presentationTaskParms.getTargetIds().length; ++i) {
                                Trace.trace(TRACE_MASKF, "PTP[" + i + "]:" + this.presentationTaskParms.getTargetIds()[i].toString());
                            }
                            new FrameworkLog(ActivationProfileListErrorIds._logInfo, -23290).log(LogAttributes.INFO_LOG);
                        }
                        throw throwable;
                    }
                    Trace.trace(TRACE_MASKF, "objId was null for: " + profile);
                    for (int i = 0; i < this.presentationTaskParms.getTargetIds().length; ++i) {
                        Trace.trace(TRACE_MASKF, "PTP[" + i + "]:" + this.presentationTaskParms.getTargetIds()[i].toString());
                    }
                    new FrameworkLog(ActivationProfileListErrorIds._logInfo, -23290).log(LogAttributes.INFO_LOG);
                }
                LocalizableText errorMsg = null;
                if (impl != null && objId != null) {
                    boolean success;
                    block31: {
                        success = false;
                        try {
                            Trace.trace(TRACE_MASKF, "asking the impl to delete the profile");
                            ProfileReport[] report = impl.deleteProfile(new HwmcaObject[]{this.getObjectForId(objId)}, new ActivationProfile[]{profile});
                            if (report != null && report[0] != null && report[0].getCompletionCode() != null && report[0].getCompletionCode().equals(CompletionReportCode.SUCCESS)) {
                                success = true;
                                this.util.deleteProfile(profile, impl);
                                break block31;
                            }
                            if (report != null && report[0] != null) {
                                errorMsg = report[0].getText();
                            }
                        }
                        catch (HException he) {
                            new FrameworkLog(ActivationProfileListErrorIds._logInfo, -23291, he).log(LogAttributes.INFO_LOG);
                            throw new TaskletException(he);
                        }
                    }
                    this.destroyBusyDialog();
                    HashMap<String, Object> updateData = new HashMap<String, Object>();
                    updateData.put("command", "DeleteButton");
                    if (success) {
                        this.showDeleteSuccess();
                        updateData.put("DeleteButton", Boolean.TRUE);
                    } else {
                        if (errorMsg == null) {
                            this.showDeleteFail("");
                        } else {
                            this.showDeleteFail(errorMsg.toString());
                        }
                        updateData.put("DeleteButton", Boolean.FALSE);
                    }
                    response.update(profile.getMachineName().toString(), updateData);
                    break block33;
                } else {
                    response.terminate();
                }
                break block33;
            }
            Trace.trace(TRACE_MASKT, "not ok to delete");
            response.noAction();
        }
        Trace.trace(TRACE_MASKF, "<- ActivationProfileListTasklet.handleDelete()");
    }

    void handleCustomize(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        Trace.trace(TRACE_MASKF, "-> ActivationProfileListTasklet.handleCustomize()");
        try {
            boolean readOnly = this.viewOnly;
            if (!readOnly) {
                readOnly = ((ActivationProfile)request.getData("profile")).isReadOnly();
            }
            this.lastEditedProfile = (ActivationProfile)request.getData("profile");
            this.util.editProfile((ActivationProfile)request.getData("profile"), this, response, readOnly);
        }
        catch (HException he) {
            throw new TaskletException(he);
        }
        Trace.trace(TRACE_MASKF, "<- ActivationProfileListTasklet.handleCustomize()");
    }

    public void propertyChange(PropertyChangeEvent evt) {
        Trace.trace(TRACE_MASKF, "-> ActivationProfileListTasklet.propertyChange()");
        Trace.trace(TRACE_MASKF, "Property Name: " + evt.getPropertyName());
        Trace.trace(TRACE_MASKF, "Old Value: " + evt.getOldValue());
        Trace.trace(TRACE_MASKF, "New Value: " + evt.getNewValue());
        if (evt.getOldValue() instanceof PanelTasklet && evt.getNewValue() == null) {
            Trace.trace(TRACE_MASKF, "redirecting");
            PanelTaskletRequest newRequest = new PanelTaskletRequest(this.getClass().getName() + "redirect");
            newRequest.setData("command", "CmdRedirect");
            try {
                this.postRequest("ProfileListFrame", newRequest);
            }
            catch (TaskletException te) {
                Trace.trace(TRACE_MASKF, te);
            }
        }
        Trace.trace(TRACE_MASKF, "<- ActivationProfileListTasklet.propertyChange()");
    }

    private boolean okToDelete(ActivationProfile profile) throws TaskletException {
        Trace.trace(TRACE_MASKF, "-> ActivationProfileListTasklet.okToDelete()");
        boolean flag = false;
        Object[] subst = new String[]{profile.getMachineName().toString(), profile.getProfileName().toString(), profile.getProfileType().toString(), profile.getProfileDescription().toString()};
        MessageText[] bmt = new BaseMessageText[]{new BaseMessageText("xpro.delete.yousure", subst)};
        LocalizableText answer = this.showMessageBox(true, this.getTask().getUIInfo().getUnlocalizedName(), bmt, bmt[0].getMsgId(), bmt[0].getMsgType(), new LocalizableText[]{new LocalizableText("com/ibm/hwmca/fw/res/common", "button.yes"), new LocalizableText("com/ibm/hwmca/fw/res/common", "button.no")});
        flag = answer != null && answer.equals(new LocalizableText("com/ibm/hwmca/fw/res/common", "button.yes"));
        Trace.trace(TRACE_MASKF, "   flag = " + flag);
        Trace.trace(TRACE_MASKF, "<- ActivationProfileListTasklet.okToDelete()");
        return flag;
    }

    private void showDeleteSuccess() throws TaskletException {
        Trace.trace(TRACE_MASKF, "-> ActivationProfileListTasklet.showDeleteSuccess()");
        MessageText[] bmt = new BaseMessageText[]{new BaseMessageText("xpro.delete.success", null)};
        this.showMessageBox(true, this.getTask().getUIInfo().getUnlocalizedName(), bmt, bmt[0].getMsgId(), bmt[0].getMsgType(), new LocalizableText[]{new LocalizableText("com/ibm/hwmca/fw/res/common", "button.ok")});
        Trace.trace(TRACE_MASKF, "<- ActivationProfileListTasklet.showDeleteSuccess()");
    }

    private void showDeleteFail(String msg) throws TaskletException {
        Trace.trace(TRACE_MASKF, "-> ActivationProfileListTasklet.showDeleteFail()");
        Object[] subst = new String[]{msg};
        MessageText[] bmt = new BaseMessageText[]{new BaseMessageText("xpro.delete.fail", subst)};
        this.showMessageBox(true, this.getTask().getUIInfo().getUnlocalizedName(), bmt, bmt[0].getMsgId(), bmt[0].getMsgType(), new LocalizableText[]{new LocalizableText("com/ibm/hwmca/fw/res/common", "button.ok")});
        Trace.trace(TRACE_MASKF, "<- ActivationProfileListTasklet.showDeleteFail()");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

